package com.hero.objects.skills;

import org.jdom.Element;

import com.hero.objects.GenericObject;
import com.hero.util.Constants;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CharacteristicChoice extends GenericObject {

	protected int characteristic;

	public CharacteristicChoice(Element template) {
		super(template);
	}

	@Override
	public boolean equals(Object o) {
		if (o instanceof CharacteristicChoice) {
			CharacteristicChoice comp = (CharacteristicChoice) o;
			return comp.getCharacteristic() == getCharacteristic();
		} else {
			return false;
		}
	}

	/**
	 * Returns the Characteristic that is contained by this object.
	 * 
	 * @see com.hero.util.Constants
	 * @return
	 */
	public int getCharacteristic() {
		return characteristic;
	}

	@Override
	public int hashCode() {
		return getCharacteristic();
	}

	@Override
	protected void init(Element element) {
		characteristic = Constants.GENERAL;
		super.init(element);
		String charString = XMLUtility.getValue(element, "CHARACTERISTIC");
		if ((charString == null) || (charString.trim().length() == 0)) {
			characteristic = Constants.GENERAL;
		}
		characteristic = Constants.getCharacteristicInteger(charString);
	}

	@Override
	public String toString() {
		return Constants.getCharacteristicString(characteristic);
	}
}